function mypsi = mypsi(u,order)
%Returns value for a particulair Hermite function of order order

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

if (order >= 0)	
	mypsi = H(u,order).*exp(-u.^2);
elseif (order == -1)
	mypsi = -erf(u)*sqrt(pi)/2;	
else
	mypsi = 0;
end

end

